﻿# Von Jörn Walter www.der-windows-papst.de

#Abfragen ob bereits ein Root Key besteht
Get-KdsRootKey

# Root Key erstellen wenn noch nicht vorhanden
Add-KdsRootKey -EffectiveImmediately

# Replikationszeit von 10 Stunden verkürzen aber nur in Testumgebungen ansonsten warten
Add-KdsRootKey -EffectiveTime ((Get-Date).AddHours(-10))

# Neue AD Gruppe erstellen namens SVCMSA
New-ADGroup -Name SVCMSA `
-GroupScope DomainLocal `
-Description "Gruppe fuer SVCMSA" `
-GroupCategory Security `
-SAMAccountName SVCMSA `
-PassThru

# Maschinen hinzuefuegen $ steht fuer Computerkonten
Add-ADGroupMember -Identity SVCMSA `
-Members "DC01$" `
-PassThru

# Kontrolle
Get-AdGroupMember -Identity SVCMSA

# Neuen Service Account erstellen
New-ADServiceAccount -name SVCMSA `
-DNSHostname dc01.ndsedv.de `
-ManagedPasswordIntervalInDays 42 `
-PassThru

# Server neu starten bevor die Gruppe den Servern hinzugefuegt werden kann
Invoke-Command -ComputerName DC01 -ScriptBlock {Restart-Computer -Force}
Invoke-Command -ComputerName DC01 -ScriptBlock {Install-ADServiceAccount -Identity SVCMSA}

# Den Service Account der Gruppe MSA zur Nutzung zuweisen
Set-ADServiceAccount -Identity SVCMSA `
-PrincipalsAllowedToRetrieveManagedPassword SVCMSA `
-PrincipalsAllowedToDelegateToAccount SVCMSA `
-PassThru

# Service Account installieren
Install-ADServiceAccount SVCMSA

# Kontrolle
Invoke-Command -ComputerName DC01 -ScriptBlock {Test-ADServiceAccount -Identity SVCMSA}

# Passwort eines Dienstkonto zuruecksetzen
Reset-ADServiceAccountPassword DC01

# Service Account deinstalliere
Uninstall-ADServiceAccount SVCMSA

# Task erstellen
$action = New-ScheduledTaskAction "powershell.exe" "-file C:\Temp\ReplicationsStatus.ps1"
$trigger = New-ScheduledTaskTrigger -At 07:00 -Daily 
$principal = New-ScheduledTaskPrincipal -UserID ndsedv.de\SVCMSA$ -LogonType Password
Register-ScheduledTask DFSReplicationsCheck –Action $action –Trigger $trigger –Principal $principal


#schtasks /Change /TN DFSReplication /RU "ndsedv.de\SVCMSA1$" /RP ""
#Uninstall-ADServiceAccount SVCMSA1$

